<?php
// index.php

// Stała do debugowania (ustaw na false na produkcji)
define('DEBUG_MODE', true);

// Dołącz plik z połączeniem do bazy
require_once './api/db_connect.php';

// Próba połączenia
$conn = connectToDatabase();

// Jeśli połączenie nieudane, pokaż błąd i zakończ wykonywanie skryptu
if (!$conn) {
    require_once './assets/templates/db-error.php';
    exit();
}
?>
<?php
require_once './api/db_connect.php'; // dopasuj ścieżkę

$conn = connectToDatabase();

$siteName = "Domyślna nazwa strony"; // fallback

if ($conn) {
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $key = 'shop_name';
    $stmt->bind_param("s", $key);
    $stmt->execute();
    $stmt->bind_result($value);

    if ($stmt->fetch()) {
        $siteName = $value;
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sklep z produktami cyfrowymi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Nawigacja -->
    <nav class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center">
                        <span class="text-xl font-bold text-indigo-600"><?= htmlspecialchars($siteName) ?></span>
                    </div>
                    <div class="hidden sm:ml-6 sm:flex sm:space-x-8">
                        <a href="#" class="border-indigo-500 text-gray-900 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium">Strona główna</a>
                        <a href="#" class="border-transparent text-gray-500 hover:border-gray-300 hover:text-gray-700 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium">Produkty</a>
                        <a href="#" class="border-transparent text-gray-500 hover:border-gray-300 hover:text-gray-700 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium">O nas</a>
                        <a href="#" class="border-transparent text-gray-500 hover:border-gray-300 hover:text-gray-700 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium">Kontakt</a>
                    </div>
                </div>
                <div class="hidden sm:ml-6 sm:flex sm:items-center">
                    <button class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-md text-sm font-medium">Zaloguj się</button>
                </div>
                <div class="-mr-2 flex items-center sm:hidden">
                    <button id="mobile-menu-button" type="button" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500">
                        <i data-lucide="menu"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile menu -->
        <div id="mobile-menu" class="hidden sm:hidden">
            <div class="pt-2 pb-3 space-y-1">
                <a href="#" class="bg-indigo-50 border-indigo-500 text-indigo-700 block pl-3 pr-4 py-2 border-l-4 text-base font-medium">Strona główna</a>
                <a href="#" class="border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700 block pl-3 pr-4 py-2 border-l-4 text-base font-medium">Produkty</a>
                <a href="#" class="border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700 block pl-3 pr-4 py-2 border-l-4 text-base font-medium">O nas</a>
                <a href="#" class="border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700 block pl-3 pr-4 py-2 border-l-4 text-base font-medium">Kontakt</a>
                <div class="mt-4 pl-3 pr-4">
                    <button class="w-full bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-md text-sm font-medium">Zaloguj się</button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Sekcja Hero -->
    <div class="bg-indigo-700">
        <div class="max-w-7xl mx-auto py-16 px-4 sm:py-24 sm:px-6 lg:px-8 text-center">
            <h1 class="text-4xl font-extrabold tracking-tight text-white sm:text-5xl lg:text-6xl">
                Najlepsze produkty cyfrowe
            </h1>
            <p class="mt-6 max-w-3xl mx-auto text-xl text-indigo-100">
                Odkryj naszą kolekcję wysokiej jakości produktów cyfrowych, które pomogą Ci rozwijać swoją działalność i kreatywność.
            </p>
            <div class="mt-10">
                <a href="#" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-indigo-700 bg-white hover:bg-indigo-50">
                    Przeglądaj produkty
                    <i data-lucide="arrow-right" class="ml-2 w-5 h-5"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Sekcja produktów -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-2xl font-bold text-gray-900">Nasze produkty</h2>
            <div class="relative">
                <select class="appearance-none bg-white border border-gray-300 rounded-md pl-3 pr-8 py-2 text-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    <option>Sortuj według</option>
                    <option>Cena: od najniższej</option>
                    <option>Cena: od najwyższej</option>
                    <option>Najnowsze</option>
                    <option>Najpopularniejsze</option>
                </select>
                <i data-lucide="chevron-down" class="absolute right-3 top-2.5 h-4 w-4 text-gray-400"></i>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            <!-- Produkt 1 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Szablon strony internetowej</h3>
                    <p class="text-gray-500 text-sm mb-3">Profesjonalny szablon dla firm</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$49.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 2 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Pakiet ikon premium</h3>
                    <p class="text-gray-500 text-sm mb-3">500+ wektorowych ikon</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$29.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 3 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">E-book: Marketing cyfrowy</h3>
                    <p class="text-gray-500 text-sm mb-3">Kompletny przewodnik</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$19.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 4 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Kurs programowania</h3>
                    <p class="text-gray-500 text-sm mb-3">Od podstaw do zaawansowanych technik</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$99.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 5 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Presety Lightroom</h3>
                    <p class="text-gray-500 text-sm mb-3">50 profesjonalnych presetów</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$24.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 6 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Szablon prezentacji</h3>
                    <p class="text-gray-500 text-sm mb-3">Dla PowerPoint i Google Slides</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$14.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 7 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Pakiet czcionek</h3>
                    <p class="text-gray-500 text-sm mb-3">10 unikalnych rodzin czcionek</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$39.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Produkt 8 -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="bg-gray-100 h-48 flex items-center justify-center">
                    <i data-lucide="image" class="w-16 h-16 text-gray-400"></i>
                </div>
                <div class="p-4">
                    <h3 class="text-lg font-medium text-gray-900 mb-1">Wtyczka do WordPress</h3>
                    <p class="text-gray-500 text-sm mb-3">Optymalizacja SEO</p>
                    <div class="flex justify-between items-center">
                        <span class="text-lg font-bold text-indigo-600">$59.99</span>
                        <button class="text-indigo-600 hover:text-indigo-800">
                            <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-10 flex justify-center">
            <button class="bg-white border border-gray-300 rounded-md px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">
                Załaduj więcej
            </button>
        </div>
    </div>

    <!-- Stopka -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div>
                    <h3 class="text-lg font-semibold mb-4">DigitalShop</h3>
                    <p class="text-gray-400">Najlepsze produkty cyfrowe dla Twoich potrzeb.</p>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Produkty</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-gray-400 hover:text-white">Szablony</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">Ikony</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">E-booki</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">Kursy</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Firma</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-gray-400 hover:text-white">O nas</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">Blog</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">Kariera</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-white">Kontakt</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Newsletter</h3>
                    <p class="text-gray-400 mb-4">Zapisz się do naszego newslettera.</p>
                    <div class="flex">
                        <input type="email" placeholder="Twój email" class="px-3 py-2 rounded-l-md text-gray-900 w-full">
                        <button class="bg-indigo-600 hover:bg-indigo-700 px-4 py-2 rounded-r-md">
                            <i data-lucide="send" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="mt-12 pt-8 border-t border-gray-700 text-center text-gray-400">
                <p>&copy; 2023 DigitalShop. Wszystkie prawa zastrzeżone.</p>
            </div>
        </div>
    </footer>

    <script>
        // Inicjalizacja ikon Lucide
        lucide.createIcons();

        // Obsługa menu mobilnego
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');

        mobileMenuButton.addEventListener('click', () => {
            const isOpen = mobileMenu.classList.contains('hidden');
            if (isOpen) {
                mobileMenu.classList.remove('hidden');
            } else {
                mobileMenu.classList.add('hidden');
            }
        });
    </script>
</body>
</html>