<?php
session_start();

// Sprawdź, czy użytkownik jest zalogowany
if (!isset($_SESSION['user'])) {
    header('Location: ../auth/login.php');
    exit;
}

?>
<?php

if (!isset($_SESSION['user'])) {
    exit;
}

$username = $_SESSION['user']['username'];
?>
    <?php
    // Twój kod PHP z wyświetlaniem powiadomień
    require_once '../api/db_connect.php';

    $conn = connectToDatabase();

    $userId = $_SESSION['user']['id'];

    $sql = "SELECT id, message, is_read, created_at FROM notifications WHERE user_id = ? ORDER BY created_at DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    ?>

<div id="notificationMenu" class="notification-menu">
  <div class="notification-header">
    <h3>Powiadomienia</h3>
    <button class="clear-all">Wyczyść wszystko</button>
  </div>
  <ul class="notification-list">
    <?php
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $class = $row['is_read'] ? '' : 'unread';
            echo '<li class="notification-item ' . $class . '">';
            echo '<p>' . htmlspecialchars($row['message']) . '</p>';
            echo '<small>' . $row['created_at'] . '</small>';
            echo '</li>';
        }
    } else {
        echo '<li class="notification-item">Brak powiadomień</li>';
    }
    ?>
  </ul>
</div>

<?php
$stmt->close();
$conn->close();
?>

<?php
// index.php

// Dołącz plik z połączeniem do bazy
require_once '../api/db_connect.php';

// Próba połączenia
$conn = connectToDatabase();

// Jeśli połączenie nieudane, pokaż błąd i zakończ wykonywanie skryptu
if (!$conn) {
    require_once '../assets/templates/db-error.php';
    exit();
}
?>
<!DOCTYPE html>
<html lang="pl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>AZDash</title>
  <script src="https://unpkg.com/lucide@latest"></script>
  <link href='../libs/boxicons/boxicons-free/free/fonts/basic/boxicons.css' rel='stylesheet'>
  <link rel="stylesheet" href="../assets/css/admin-panel.css" />
  <script src="../assets/js/notify.js"></script>
  <script>
document.querySelector('.clear-all').addEventListener('click', () => {
  fetch('../api/clear_notifications.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json'
    }
  })
  .then(response => response.json())
  .then(data => {
    if (data.status === 'success') {
      // Zamiast alertu, usuń wizualnie powiadomienia
      const notificationsContainer = document.querySelector('.notifications-container');
      if (notificationsContainer) {
        notificationsContainer.innerHTML = ''; // Usuń wszystkie elementy w kontenerze
        // Możesz też usunąć każdy element powiadomienia pojedynczo:
        // const notificationItems = document.querySelectorAll('.notification-item');
        // notificationItems.forEach(item => item.remove());
      }
      console.log('Powiadomienia usunięte pomyślnie.');
      // Opcjonalnie: możesz wyświetlić jakiś subtelny komunikat,
      // np. zmieniając tekst jakiegoś elementu na krótko.
    } else if (data.error) {
      console.error('Błąd:', data.error);
      // Tutaj możesz wyświetlić komunikat o błędzie w interfejsie użytkownika,
      // np. w jakimś divie z komunikatem o błędzie.
      const errorContainer = document.getElementById('error-message'); // Załóżmy, że masz taki element
      if (errorContainer) {
        errorContainer.textContent = 'Błąd: ' + data.error;
        // Opcjonalnie: możesz dodać jakąś klasę CSS, aby go wyróżnić
      }
    }
  })
  .catch(error => {
    console.error('Błąd połączenia:', error);
    // Podobnie jak wyżej, możesz wyświetlić komunikat o błędzie połączenia w UI.
    const errorContainer = document.getElementById('connection-error'); // Załóżmy, że masz taki element
    if (errorContainer) {
      errorContainer.textContent = 'Błąd połączenia: ' + error;
    }
  });
});
    </script>
  <style>
#mobileMenuButton {
  display: none;
}

@media (max-width: 992px) {
  .icon-button {
    display: block !important;
  }
}

</style>
</head>
<body>
  <div class="dashboard-container">
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
      <div class="brand">AZDash</div>
      <nav class="nav">
        <a href="/admin.html" class="nav-link active"><i data-lucide="layout-dashboard"></i> Dashboard</a>
        <a href="/users.html" class="nav-link"><i data-lucide="users"></i> Użytkownicy</a>
        <a href="/products.php" class="nav-link"><i data-lucide="folder"></i> Produkty</a>
        <a href="/settings.html" class="nav-link"><i data-lucide="settings"></i> Ustawienia</a>
      </nav>
      <div class="logout">
        <a href="/final-app/auth/logout.php" class="logout-link"><i data-lucide="log-out"></i> Wyloguj</a>
      </div>
    </aside>
    <!-- Main content -->
    <div class="main-content">
      <!-- Top bar -->
      <header class="topbar">
      <button id="mobileMenuButton" class="icon-button mobile-menu-button">
  <i data-lucide="menu"></i>
</button>
        <div class="topbar-title-container">
          <div>
            <h1 class="title">Witaj, <?php echo $username; ?></h1>
            <p class="subtitle">Zarządzaj swoim panelem</p>
          </div>
        </div>
        <div class="user-panel">
          
         <!-- <button id="themeToggle" class="icon-button">
            <i data-lucide="moon" class="dark-hidden"></i>
            <i data-lucide="sun" class="dark-inline hidden"></i>
          </button> -->
          <button id="notificationButton" class="icon-button">
            <i data-lucide="bell"></i>
          </button>
          

          
          <div id="modal-notify" class="modal-notify hidden">
            <div class="modal-header">
              <h2>Szczegóły powiadomienia</h2>
              <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
            </div>
            <div class="modal-body">
              <p class="notification-content">Ładowanie...</p>
              <div class="notification-actions">
                <!-- Akcje jak Wyczyść powiadomienie -->
              </div>
            </div>
          </div>
          
          <img src="https://i.pravatar.cc/40?img=12" alt="Avatar" class="avatar" onclick="openModal('modal-profile')"/>
        </div>
      </header>

      <!-- Content -->
      <main class="main">
        <div class="cards">
        <div class="card" onclick="openModal('modal-user')">
    <div class="card-header">
        <h2>Nowi użytkownicy</h2>
        <i data-lucide="user-plus" class="icon-blue"></i>
    </div>
    <?php
    // Funkcja do obliczania liczby nowych użytkowników w danym okresie
    function getNewUsersCount($conn, $startDate, $endDate) {
        $sql = "SELECT COUNT(*) AS new_users FROM users WHERE created_at >= ? AND created_at < ?";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("ss", $startDate, $endDate);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($result && $result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $stmt->close();
                return $row['new_users'] ?? 0;
            }
            $stmt->close();
        }
        return 0;
    }

    // Ustalenie dat dla bieżącego miesiąca
    $currentDate = new DateTime();
    $currentMonthStart = $currentDate->modify('first day of this month')->setTime(0, 0, 0)->format('Y-m-d H:i:s');
    $currentMonthEnd = $currentDate->modify('last day of this month')->setTime(23, 59, 59)->format('Y-m-d H:i:s');

    // Ustalenie dat dla poprzedniego miesiąca
    $previousMonthEnd = (new DateTime($currentMonthStart))->modify('-1 day')->setTime(23, 59, 59)->format('Y-m-d H:i:s');
    $previousMonthStart = (new DateTime($previousMonthEnd))->modify('first day of this month')->setTime(0, 0, 0)->format('Y-m-d H:i:s');

    // Pobranie liczby nowych użytkowników dla bieżącego i poprzedniego miesiąca
    $currentMonthNewUsers = getNewUsersCount($conn, $currentMonthStart, $currentMonthEnd);
    $previousMonthNewUsers = getNewUsersCount($conn, $previousMonthStart, $previousMonthEnd);

    // Obliczenie procentowego wzrostu
    $percentageGrowth = 0;
    if ($previousMonthNewUsers != 0) {
        $difference = $currentMonthNewUsers - $previousMonthNewUsers;
        $percentageGrowth = ($difference / $previousMonthNewUsers) * 100;
    }

    echo '<p class="stat blue">' . $currentMonthNewUsers . '</p>';
    echo '<p class="description">';
    if ($percentageGrowth > 0) {
        echo 'Wzrost o ' . number_format($percentageGrowth, 2) . '% w tym miesiącu';
    } elseif ($percentageGrowth < 0) {
        echo 'Spadek o ' . number_format(abs($percentageGrowth), 2) . '% w tym miesiącu';
    } else {
        echo 'Bez zmian w porównaniu do poprzedniego miesiąca';
    }
    echo '</p>';
    ?>
</div>
          <div class="card" onclick="openModal('modal-sales')">
    <div class="card-header">
        <h2>Sprzedaż <span id="data"></span></h2>
        <i data-lucide="shopping-cart" class="icon-green"></i>
    </div>
    <?php
    // Funkcja do obliczania sprzedaży w danym okresie
    function getWeeklySales($conn, $startDate, $endDate) {
      $sql = "SELECT SUM(total) AS weekly_revenue FROM orders WHERE status = 'completed' AND created_at >= ? AND created_at < ?";
      $stmt = $conn->prepare($sql);
      if ($stmt) {
          $stmt->bind_param("ss", $startDate, $endDate);
          $stmt->execute();
          $result = $stmt->get_result();
          if ($result && $result->num_rows > 0) {
              $row = $result->fetch_assoc();
              $stmt->close();
              return $row['weekly_revenue'] ?? 0;
          }
          $stmt->close();
      }
      return 0;
  }

    // Ustalenie dat dla aktualnego tygodnia (od poniedziałku do niedzieli)
    $currentDate = new DateTime();
    $currentWeekStart = $currentDate->modify('last monday')->setTime(0, 0, 0)->format('Y-m-d H:i:s');
    $currentWeekEnd = $currentDate->modify('next sunday')->setTime(23, 59, 59)->format('Y-m-d H:i:s');

    // Ustalenie dat dla poprzedniego tygodnia
    $previousWeekStart = (new DateTime($currentWeekStart))->modify('-7 days')->format('Y-m-d H:i:s');
    $previousWeekEnd = (new DateTime($currentWeekEnd))->modify('-7 days')->format('Y-m-d H:i:s');

    // Pobranie sprzedaży dla aktualnego i poprzedniego tygodnia
    $currentWeekSales = getWeeklySales($conn, $currentWeekStart, $currentWeekEnd);
    $previousWeekSales = getWeeklySales($conn, $previousWeekStart, $previousWeekEnd);

    // Obliczenie procentowej różnicy
    $percentageDifference = 0;
    if ($previousWeekSales != 0) {
        $difference = $currentWeekSales - $previousWeekSales;
        $percentageDifference = ($difference / $previousWeekSales) * 100;
    }

    echo '<p class="stat green">' . number_format((float)$currentWeekSales, 2, ',', ' ') . ' zł</p>';
    echo '<p class="description">';
    if ($percentageDifference > 0) {
        echo '+' . number_format($percentageDifference, 2) . '% od zeszłego tygodnia';
    } elseif ($percentageDifference < 0) {
        echo number_format($percentageDifference, 2) . '% od zeszłego tygodnia';
    } else {
        echo 'Bez zmian w porównaniu do zeszłego tygodnia';
    }
    echo '</p>';
    ?>
</div>
          <div class="card" onclick="openModal('modal-orders')">
    <div class="card-header">
        <h2>Zamówienia</h2>
        <i data-lucide="box" class="icon-purple"></i>
    </div>
    <?php
    // Pobierz liczbę wszystkich zamówień
    $sqlTotalOrders = "SELECT COUNT(*) AS total FROM orders";
    $resultTotalOrders = $conn->query($sqlTotalOrders);
    $totalOrdersCount = 0;
    if ($resultTotalOrders && $resultTotalOrders->num_rows > 0) {
        $rowTotalOrders = $resultTotalOrders->fetch_assoc();
        $totalOrdersCount = $rowTotalOrders['total'];
    }

    // Pobierz liczbę oczekujących zamówień
    $sqlPendingOrders = "SELECT COUNT(*) AS pending FROM orders WHERE status = 'pending'";
    $resultPendingOrders = $conn->query($sqlPendingOrders);
    $pendingOrdersCount = 0;
    if ($resultPendingOrders && $resultPendingOrders->num_rows > 0) {
        $rowPendingOrders = $resultPendingOrders->fetch_assoc();
        $pendingOrdersCount = $rowPendingOrders['pending'];
    }
    echo '<p class="stat purple">' . $totalOrdersCount . '</p>';
    echo '<p class="description">Oczekujących: ' . $pendingOrdersCount . '</p>';
    ?>
</div>
          <div class="card financial-summary">
    <div class="card-header">
        <h2>Podsumowanie finansowe</h2>
        <i data-lucide="bar-chart-3" class="icon-orange"></i>
    </div>
    <?php
    // Suma przychodów
    $sql = "SELECT SUM(total) AS total_revenue FROM orders WHERE status = 'completed'";
    $result = $conn->query($sql);
    $totalRevenue = '0,00'; // Domyślna wartość
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        if (isset($row['total_revenue']) && $row['total_revenue'] !== null) {
            $totalRevenue = number_format((float)$row['total_revenue'], 2, ',', ' ');
        }
    }
    echo '<p class="stat orange">' . $totalRevenue . ' zł</p>';
    ?>
    <p class="description">Całkowity przychód ze zrealizowanych zamówień</p>

    <div class="summary-details">
        <div class="summary-item">
            <span class="label">Transakcje:</span>
            <?php
            $sql = "SELECT COUNT(*) AS total_orders FROM orders WHERE status = 'completed'";
            $result = $conn->query($sql);
            $totalOrders = 0; // Domyślna wartość
            if ($result && $result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $totalOrders = (int)$row['total_orders'];
            }
            echo '<span class="value">' . $totalOrders . '</span>';
            ?>
        </div>
        <div class="summary-item">
            <span class="label">Średnia wartość zamówienia:</span>
            <?php
            $sql = "SELECT AVG(total) AS average_revenue FROM orders WHERE status = 'completed'";
            $result = $conn->query($sql);
            $averageRevenue = '0,00'; // Domyślna wartość
            if ($result && $result->num_rows > 0) {
                $row = $result->fetch_assoc();
                if (isset($row['average_revenue']) && $row['average_revenue'] !== null) {
                    $averageRevenue = number_format((float)$row['average_revenue'], 2, ',', ' ');
                }
            }
            echo '<span class="value">' . $averageRevenue . ' zł</span>';
            ?>
        </div>
        <div class="summary-item">
            <span class="label">Najlepszy produkt:</span>
            <?php
            $sqlBestProduct = "SELECT p.name, SUM(oi.quantity) AS total_sold
                                FROM order_items oi
                                JOIN products p ON oi.product_id = p.id
                                JOIN orders o ON oi.order_id = o.id
                                WHERE o.status = 'completed'
                                GROUP BY oi.product_id
                                ORDER BY total_sold DESC
                                LIMIT 1";
            $resultBestProduct = $conn->query($sqlBestProduct);
            $bestProductName = "Brak danych";
            if ($resultBestProduct && $resultBestProduct->num_rows > 0) {
                $rowBestProduct = $resultBestProduct->fetch_assoc();
                $bestProductName = $rowBestProduct['name'];
            }
            echo '<span class="value">' . $bestProductName . '</span>';
            ?>
        </div>
    </div>
</div>

    </div>
</div>
          </div>
        </div>
      </main>
    </div>
  </div>

  <!-- Modale -->
  <div id="modal-overlay" class="modal-overlay hidden"></div>

  <div id="modal-user" class="modal hidden">
    <div class="modal-header">
      <h2>Statystyki użytkowników</h2>
      <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
    </div>
    <div class="modal-body">
      <canvas id="userChart"></canvas>
    </div>
  </div>

  <div id="modal-profile" class="modal hidden">
    <div class="modal-header">
      <h2>Edytuj profil</h2>
      <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
    </div>
    <div class="modal-body">
      <!-- Formularz edycji profilu -->
    </div>
  </div>

  <div id="modal-sales" class="modal hidden">
    <div class="modal-header">
      <h2>Informacje o sprzedaży</h2>
      <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
    </div>
    <div class="modal-body">
      <p>Sprzedaż rośnie stabilnie. Oczekujemy dalszego wzrostu w Q3.</p>
    </div>
  </div>

  <div id="modal-orders" class="modal hidden">
    <div class="modal-header">
      <h2>Zamówienia</h2>
      <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
    </div>
    <div class="modal-body">
      <table class="orders-table">
        <thead>
          <tr>
            <th>ID</th>
            <th>Klient</th>
            <th>Status</th>
            <th>Akcje</th>
          </tr>
        </thead>
        <tbody id="orders-list">
          <!-- Wypełniane przez JS -->
        </tbody>
      </table>

      <div id="order-info" class="hidden order-details">
        <h3>Szczegóły zamówienia</h3>
        <p><strong>ID:</strong> <span id="info-id"></span></p>
        <p><strong>Klient:</strong> <span id="info-client"></span></p>
        <p><strong>Status:</strong> <span id="info-status"></span></p>
        <p><strong>Produkty:</strong> <span id="info-products"></span></p>
      </div>
    </div>
  </div>



<script>
document.addEventListener('DOMContentLoaded', function() {
  const sidebar = document.getElementById('sidebar');
  const menuToggle = document.getElementById('mobileMenuButton');
  const sidebarOverlay = document.getElementById('sidebar-overlay');
  if (!sidebar) {
      console.error('Element #sidebar nie istnieje');
      return;
  }
  if (!menuToggle) {
      console.error('Element #mobileMenuButton nie istnieje');
      return;
  }
  if (!sidebarOverlay) {
      console.error('Element #sidebar-overlay nie istnieje');
      return;
  }
  function toggleSidebar() {
      sidebar.classList.toggle('active');
      sidebarOverlay.classList.toggle('active');
  }
  menuToggle.addEventListener('click', toggleSidebar);
  sidebarOverlay.addEventListener('click', toggleSidebar);
  document.addEventListener('click', function(e) {
      if (window.innerWidth <= 768 &&
          !sidebar.contains(e.target) &&
          e.target !== menuToggle &&
          !menuToggle.contains(e.target)) {
          toggleSidebar();
      }
  });
  lucide.createIcons();
});
</script>

<div id="sidebar-overlay"></div>

</body>
</html>