<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Błąd połączenia z bazą danych</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #fdfdfd;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .error-container {
            background-color: #fff;
            border-left: 8px solid #ff9800; /* Pomarańczowy pasek alertu */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            padding: 30px;
            max-width: 500px;
            width: 95%;
            border-radius: 4px;
        }
        .error-icon {
            font-size: 50px;
            color: #ff9800;
            margin-bottom: 15px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-weight: bold;
        }
        .error-message {
            color: #555;
            margin-bottom: 25px;
            line-height: 1.5;
        }
        .error-details {
            background-color: #fffbe6;
            border: 1px solid #ffe082;
            color: #795548;
            padding: 12px;
            border-radius: 3px;
            margin-bottom: 25px;
            text-align: left;
            font-size: 0.85em;
        }
        .error-details strong {
            font-weight: bold;
            color: #5d4037;
        }
        .error-actions {
            display: flex;
            gap: 8px;
            justify-content: flex-start;
        }
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s ease-in-out, color 0.2s ease-in-out;
        }
        .btn-retry {
            background-color: #4caf50; /* Zielony - akcja pozytywna */
            color: white;
        }
        .btn-retry:hover {
            background-color: #388e3c;
        }
        .btn-contact {
            background-color: #2196f3; /* Niebieski - informacyjny */
            color: white;
        }
        .btn-contact:hover {
            background-color: #1976d2;
        }
        .btn-home {
            background-color: #f44336; /* Czerwony - powrót/anulowanie */
            color: white;
        }
        .btn-home:hover {
            background-color: #d32f2f;
        }
        .additional-info {
            margin-top: 30px;
            padding: 15px;
            background-color: #f5f5f5;
            border-radius: 3px;
            text-align: left;
            color: #777;
            font-size: 0.85em;
        }
        .additional-info h2 {
            color: #333;
            margin-top: 0;
            margin-bottom: 10px;
            font-weight: bold;
            font-size: 1em;
        }
        .additional-info ul {
            padding-left: 20px;
            list-style: square;
        }
        .additional-info li {
            margin-bottom: 6px;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="error-container">
        <div class="error-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <h1>WYSTĄPIŁ BŁĄD</h1>
        <p class="error-message">Nie można połączyć się z serwerem bazy danych. Prosimy o podjęcie odpowiednich kroków.</p>

        <?php if (defined('DEBUG_MODE') && DEBUG_MODE): ?>
        <div class="error-details">
            <p><strong>Szczegóły techniczne:</strong></p>
            <ul>
                <li><strong>Błąd:</strong> <?php echo mysqli_connect_error(); ?></li>
                <li><strong>Kod:</strong> <?php echo mysqli_connect_errno(); ?></li>
                <li><strong>Plik:</strong> <?php echo __FILE__ . ":" . __LINE__; ?></li>
                <?php if (isset($_SERVER['SERVER_ADDR'])): ?>
                <li><strong>Serwer:</strong> <?php echo $_SERVER['SERVER_ADDR']; ?></li>
                <?php endif; ?>
            </ul>
        </div>
        <?php endif; ?>

        <div class="error-actions">
            <button class="btn btn-retry" onclick="window.location.reload()"><i class="fas fa-sync-alt"></i> Spróbuj ponownie</button>
            <button class="btn btn-contact"><i class="fas fa-question-circle"></i> Pomoc</button>
            <a href="/" class="btn btn-home"><i class="fas fa-arrow-left"></i> Wróć</a>
        </div>

        <div class="additional-info">
            <h2>Co teraz?</h2>
            <ul>
                <li>Sprawdź, czy inne strony działają poprawnie.</li>
                <li>Odczekaj kilka minut i spróbuj ponownie.</li>
                <li>Jeśli problem nadal występuje, skontaktuj się z administratorem.</li>
            </ul>
        </div>
    </div>
</body>
</html>