<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Błąd połączenia z bazą danych</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f9f9f9;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .error-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            padding: 40px;
            text-align: center;
            max-width: 550px;
            width: 95%;
        }
        .error-icon {
            font-size: 80px;
            color: #d9534f; /* Mocny czerwony */
            margin-bottom: 20px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-weight: 600;
        }
        .error-message {
            color: #666;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        .error-details {
            background-color: #fdecea;
            border: 1px solid #d9534f;
            color: #d9534f;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 30px;
            text-align: left;
            font-size: 0.9em;
        }
        .error-details strong {
            font-weight: bold;
        }
        .error-actions {
            display: flex;
            gap: 10px;
            justify-content: center;
        }
        .btn {
            padding: 10px 20px;
            border: 2px solid #d9534f;
            border-radius: 6px;
            cursor: pointer;
            font-size: 15px;
            transition: background-color 0.2s ease-in-out, color 0.2s ease-in-out;
            background-color: transparent;
            color: #d9534f;
        }
        .btn:hover {
            background-color: #d9534f;
            color: white;
        }
        .additional-info {
            margin-top: 30px;
            padding: 20px;
            background-color: #eee;
            border-radius: 4px;
            text-align: left;
            color: #555;
            font-size: 0.9em;
        }
        .additional-info h2 {
            color: #333;
            margin-top: 0;
            margin-bottom: 15px;
            font-weight: 500;
        }
        .additional-info ul {
            padding-left: 20px;
            list-style: disc;
        }
        .additional-info li {
            margin-bottom: 8px;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="error-container">
        <div class="error-icon">
            <i class="fas fa-unlink"></i>
        </div>
        <h1>Błąd połączenia z bazą danych</h1>
        <p class="error-message">Nie można ustanowić połączenia z serwerem bazy danych. Sprawdź status serwera i konfigurację.</p>

        <?php if (defined('DEBUG_MODE') && DEBUG_MODE): ?>
        <div class="error-details">
            <p><strong>Szczegóły:</strong></p>
            <ul>
                <li><strong>Komunikat:</strong> <?php echo mysqli_connect_error(); ?></li>
                <li><strong>Kod:</strong> <?php echo mysqli_connect_errno(); ?></li>
                <li><strong>Lokalizacja:</strong> <?php echo __FILE__ . ":" . __LINE__; ?></li>
                <?php if (isset($_SERVER['SERVER_ADDR'])): ?>
                <li><strong>Serwer IP:</strong> <?php echo $_SERVER['SERVER_ADDR']; ?></li>
                <?php endif; ?>
            </ul>
            <p><small>Tylko w trybie debugowania.</small></p>
        </div>
        <?php endif; ?>

        <div class="error-actions">
            <button class="btn btn-retry" onclick="window.location.reload()"><i class="fas fa-refresh"></i> Odśwież</button>
            <button class="btn btn-contact"><i class="fas fa-support"></i> Wsparcie</button>
            <a href="/" class="btn btn-home"><i class="fas fa-home"></i> Strona główna</a>
        </div>

        <div class="additional-info">
            <h2>Wskazówki:</h2>
            <ul>
                <li>Upewnij się, że serwer bazy danych działa.</li>
                <li>Sprawdź konfigurację połączenia w pliku konfiguracyjnym.</li>
                <li>Skontaktuj się z administratorem serwera, jeśli problem się powtarza.</li>
            </ul>
            <p>Przepraszamy za niedogodności.</p>
        </div>
    </div>
</body>
</html>