<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Błąd połączenia z bazą danych</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .error-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 40px;
            text-align: center;
            max-width: 600px;
            width: 95%;
            border: 1px solid #eee;
        }
        .error-icon {
            font-size: 70px;
            color: #d32f2f; /* Mocny czerwony akcent */
            margin-bottom: 20px;
        }
        h1 {
            color: #333;
            margin-bottom: 15px;
            font-weight: 500;
        }
        .error-message {
            color: #555;
            margin-bottom: 30px;
            line-height: 1.7;
        }
        .error-details {
            background-color: #ffebee;
            border: 1px solid #ef9a9a;
            color: #d32f2f;
            padding: 18px;
            border-radius: 6px;
            margin-bottom: 30px;
            text-align: left;
            font-size: 0.9em;
        }
        .error-details strong {
            font-weight: 600;
            color: #c62828;
        }
        .error-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
        }
        .btn {
            padding: 12px 22px;
            border: 2px solid #d32f2f;
            border-radius: 8px;
            cursor: pointer;
            font-size: 15px;
            transition: background-color 0.3s ease, color 0.3s ease;
            font-weight: bold;
            background-color: transparent;
            color: #d32f2f;
        }
        .btn:hover {
            background-color: #d32f2f;
            color: #fff;
        }
        .additional-info {
            margin-top: 40px;
            padding: 25px;
            background-color: #f9f9f9;
            border-radius: 6px;
            text-align: left;
            color: #777;
            font-size: 0.9em;
            border: 1px solid #eee;
        }
        .additional-info h2 {
            color: #333;
            margin-top: 0;
            margin-bottom: 15px;
            font-weight: 500;
        }
        .additional-info ul {
            padding-left: 20px;
            list-style: disc;
        }
        .additional-info li {
            margin-bottom: 8px;
        }
    </style>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;500&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="error-container">
        <div class="error-icon">
            <i class="fas fa-database"></i>
        </div>
        <h1>Błąd połączenia z bazą danych</h1>
        <p class="error-message">Nie można nawiązać stabilnego połączenia z serwerem bazy danych.</p>

        <?php if (defined('DEBUG_MODE') && DEBUG_MODE): ?>
        <div class="error-details">
            <p><strong>Szczegóły techniczne:</strong></p>
            <ul>
                <li><strong>Komunikat:</strong> <?php echo mysqli_connect_error(); ?></li>
                <li><strong>Kod:</strong> <?php echo mysqli_connect_errno(); ?></li>
                <?php if (isset($_SERVER['SERVER_ADDR'])): ?>
                <li><strong>Serwer:</strong> <?php echo $_SERVER['SERVER_ADDR']; ?></li>
                <?php endif; ?>
            </ul>
            <p><small>Widoczne tylko w trybie debugowania.</small></p>
        </div>
        <?php endif; ?>

        <div class="error-actions">
            <button class="btn btn-retry" onclick="window.location.reload()"><i class="fas fa-sync-alt"></i> Spróbuj ponownie</button>
            <button class="btn btn-contact"><i class="fas fa-envelope"></i> Kontakt</button>
            <a href="/" class="btn btn-home"><i class="fas fa-home"></i> Strona główna</a>
        </div>

        <div class="additional-info">
            <h2>Co możesz zrobić?</h2>
            <ul>
                <li>Odśwież stronę za kilka minut.</li>
                <li>Sprawdź swoje połączenie internetowe.</li>
                <li>Skontaktuj się z administratorem, jeśli problem się powtarza.</li>
            </ul>
            <p>Dziękujemy za cierpliwość.</p>
        </div>
    </div>
</body>
</html>