<?php
require_once 'db_connect.php';

// Nawiązanie połączenia z bazą danych
$conn = connectToDatabase();

// Sprawdzenie połączenia
if (!$conn) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Błąd połączenia z bazą danych']));
}

// Sprawdzenie metody żądania
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['status' => 'error', 'message' => 'Metoda nie jest obsługiwana']));
}

// Walidacja wymaganych pól
$requiredFields = ['productId', 'productName', 'productPrice'];
foreach ($requiredFields as $field) {
    if (empty($_POST[$field])) {
        http_response_code(400);
        die(json_encode(['status' => 'error', 'message' => "Pole $field jest wymagane"]));
    }
}

// Przygotowanie i sanetyzacja danych
$productId = intval($_POST['productId']);
$productName = htmlspecialchars(strip_tags($_POST['productName']));
$productPrice = floatval($_POST['productPrice']);
$productDescription = isset($_POST['productDescription']) 
    ? htmlspecialchars(strip_tags($_POST['productDescription'])) 
    : null;

// Dodatkowa walidacja danych
if ($productId <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'Nieprawidłowe ID produktu']));
}

if ($productPrice <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'Cena musi być większa od zera']));
}

// Przygotowane zapytanie SQL
$stmt = $conn->prepare("UPDATE products SET name = ?, price = ?, description = ? WHERE id = ?");
$stmt->bind_param("sdsi", $productName, $productPrice, $productDescription, $productId);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        $response = [
            'status' => 'success',
            'message' => 'Produkt został zaktualizowany',
            'product_id' => $productId
        ];
    } else {
        $response = [
            'status' => 'info',
            'message' => 'Brak zmian w produkcie',
            'product_id' => $productId
        ];
    }
    echo json_encode($response);
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Błąd przy aktualizacji produktu',
        'error_details' => $conn->error,
        'product_id' => $productId
    ]);
}

$stmt->close();
$conn->close();
?>