<?php
require_once 'db_connect.php';

// Nawiąż połączenie
$conn = connectToDatabase();

// Sprawdź czy połączenie zostało nawiązane
if (!$conn) {
    http_response_code(500);
    die(json_encode(['error' => 'Błąd połączenia z bazą danych']));
}

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // Przygotowane zapytanie z mysqli
    $stmt = $conn->prepare("DELETE FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => 'Usunięto produkt.']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Błąd podczas usuwania: ' . $conn->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Brak wymaganego parametru ID']);
}