<?php
require_once __DIR__ . '/../config.php'; // Poprawiona ścieżka

// Opcjonalnie zdefiniuj tryb debugowania, jeśli nie jest zdefiniowany
if (!defined('DEBUG_MODE')) {
    define('DEBUG_MODE', true); // Możesz ustawić na false na produkcji
}

function connectToDatabase() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

        if ($conn->connect_error) {
            throw new Exception("Connection failed: " . $conn->connect_error);
        }

        return $conn;
    } catch (Exception $e) {
        if (DEBUG_MODE) {
            error_log("Database error: " . $e->getMessage());
        }
        return false;
    }
}
?>
