<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

require_once 'db_connect.php';

$response = ['status' => 'error', 'message' => 'Unknown error'];

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception("Only POST method is allowed", 405);
    }

    $conn = connectToDatabase();
    if (!$conn) {
        throw new Exception("Database connection failed");
    }

    $name = $_POST['productName'] ?? '';
    $price = $_POST['productPrice'] ?? 0;
    $description = $_POST['productDescription'] ?? '';

    if (empty($name) || empty($price)) {
        throw new Exception("Product name and price are required", 400);
    }

    // Insert with both timestamps
    $stmt = $conn->prepare("
        INSERT INTO products (name, price, description, created_at, updated_at) 
        VALUES (?, ?, ?, NOW(), NOW())
    ");
    
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("sds", $name, $price, $description);
    
    if ($stmt->execute()) {
        $response = [
            'status' => 'success',
            'message' => 'Product added successfully',
            'product_id' => $stmt->insert_id
        ];
    } else {
        throw new Exception("Execute failed: " . $stmt->error);
    }

} catch (Exception $e) {
    http_response_code($e->getCode() >= 400 ? $e->getCode() : 500);
    $response['message'] = $e->getMessage();
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
    echo json_encode($response);
}