<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// Rozpocznij sesję na SAMYM POCZĄTKU
session_start();

// Sprawdź czy formularz został wysłany metodą POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$zipUrl = 'https://cdn.dwl.ct8.pl/packages/latest.zip'; // ← Zastąp prawdziwym URL
$localZipPath = __DIR__ . '/azshop_temp.zip';
$extractTo = dirname(__DIR__ . './'); // Główny katalog (nad instalatorem) // $extractTo = __DIR__ . './'; // lub inna podścieżka, np. 'public'
$expectedHash = '9727b9fcdc5f56acd23203a93f5de41d406e5a77'; // Opcjonalny hash SHA-1/256 pliku (dla bezpieczeństwa)

// Funkcja do pobierania przez cURL (bezpieczniejsza niż file_get_contents)
function downloadWithCurl($url, $savePath) {
    $ch = curl_init($url);
    $fp = fopen($savePath, 'wb');
    
    curl_setopt_array($ch, [
        CURLOPT_FILE => $fp,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 300, // 5 minut timeout
        CURLOPT_SSL_VERIFYPEER => true, // Weryfikacja SSL
        CURLOPT_USERAGENT => 'AZShop Installer' // Niektóre serwery wymagają User-Agent
    ]);
    
    $success = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    fclose($fp);
    
    if (!$success) {
        @unlink($savePath); // Usuń błędny plik
        die("Błąd pobierania: " . htmlspecialchars($error));
    }
    return true;
}

// 1. Pobierz plik ZIP
if (!downloadWithCurl($zipUrl, $localZipPath)) {
    die('Nie udało się pobrać pliku ZIP.');
}

// 2. Weryfikacja pliku (opcjonalna, ale zalecana)
if ($expectedHash && sha1_file($localZipPath) !== $expectedHash) {
    @unlink($localZipPath);
    die('Pobrany plik ZIP jest uszkodzony lub nieautentyczny.');
}

// 3. Sprawdź rozszerzenie ZipArchive
if (!class_exists('ZipArchive')) {
    @unlink($localZipPath);
    die('Rozszerzenie ZipArchive nie jest dostępne w PHP.');
}

// 4. Wypakuj plik
$zip = new ZipArchive();
if ($zip->open($localZipPath) !== true) {
    @unlink($localZipPath);
    die('Nie można otworzyć archiwum ZIP. Kod błędu: ' . $zip->getStatusString());
}

// Sprawdź uprawnienia do zapisu
if (!is_writable($extractTo)) {
    $zip->close();
    @unlink($localZipPath);
    die('Brak uprawnień do zapisu w katalogu: ' . htmlspecialchars($extractTo));
}

// Wypakuj z obsługą błędów
if (!$zip->extractTo($extractTo)) {
    $zip->close();
    @unlink($localZipPath);
    die('Błąd wypakowywania. Upewnij się, że serwer ma wystarczającą ilość miejsca.');
}

// Zamknij i wyczyść
$zip->close();
@unlink($localZipPath);
// Wymagane pola
$requiredFields = [
    'db_host', 'db_name', 'db_user', 
    'admin_email', 'admin_username', 'admin_password', 'admin_password_confirm',
    'shop_name', 'shop_url'
];

foreach ($requiredFields as $field) {
    if (empty($_POST[$field])) {
        die('Wypełnij wszystkie wymagane pola. Brakujące pole: ' . $field);
    }
}

// Sprawdzenie zgodności haseł
if ($_POST['admin_password'] !== $_POST['admin_password_confirm']) {
    die('Hasła nie są identyczne.');
}

// Dane bazy danych
$dbHost = $_POST['db_host'];
$dbName = $_POST['db_name'];
$dbUser = $_POST['db_user'];
$dbPass = $_POST['db_pass'] ?? '';

try {
    // Połączenie z bazą (najpierw bez wybranej bazy)
    $dsn = "mysql:host=$dbHost;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    $db = new PDO($dsn, $dbUser, $dbPass, $options);

    // Tworzenie bazy jeśli nie istnieje
    $db->exec("CREATE DATABASE IF NOT EXISTS `$dbName`");
    $db->exec("USE `$dbName`");

    // Tworzenie tabel
    require_once 'includes/database.php';
    if (!function_exists('createDatabaseTables')) {
        die('Brak funkcji createDatabaseTables w pliku database.php');
    }
    createDatabaseTables($db);

    // Tworzenie konta administratora
    $adminEmail = $_POST['admin_email'];
    $adminUsername = $_POST['admin_username'];
    $adminPassword = password_hash($_POST['admin_password'], PASSWORD_BCRYPT);
    $shop_url = filter_input(INPUT_POST, 'shop_url', FILTER_SANITIZE_URL);
    $shop_name = htmlspecialchars($_POST['shop_name']);
    $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) 
    VALUES ('shop_url', ?)
    ON DUPLICATE KEY UPDATE setting_value = ?");
    $stmt->execute([$shop_url, $shop_url]);
    
    $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) 
    VALUES ('shop_name', ?)
    ON DUPLICATE KEY UPDATE setting_value = ?");
    $stmt->execute([$shop_name, $shop_name]);
    
    if ($stmt->rowCount() > 0) {
        echo "Settings saved successfully!";
    } else {
        echo "Ustawienia były już aktualne.";
    }
    $shop_currency = htmlspecialchars($_POST['shop_currency']);
    $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) 
    VALUES ('shop_currency', :shop_currency)");
    $stmt->bindParam(':shop_currency', $shop_currency);
    $stmt->execute();
    
    $stmt = $db->prepare("INSERT INTO users (username, email, password, role, created_at, updated_at) VALUES (?, ?, ?, 'admin', NOW(), NOW())");
    $stmt->execute([$adminUsername, $adminEmail, $adminPassword]);

    // Generowanie pliku konfiguracyjnego
    $configContent = "<?php\n";
    $configContent .= "// AZShop Configuration File\n";
    $configContent .= "define('DB_HOST', '" . addslashes($dbHost) . "');\n";
    $configContent .= "define('DB_NAME', '" . addslashes($dbName) . "');\n";
    $configContent .= "define('DB_USER', '" . addslashes($dbUser) . "');\n";
    $configContent .= "define('DB_PASS', '" . addslashes($dbPass) . "');\n";
    $configContent .= "// Shop settings\n";
    $configContent .= "define('SHOP_NAME', '" . addslashes($_POST['shop_name']) . "');\n";
    $configContent .= "define('SHOP_URL', '" . addslashes($_POST['shop_url']) . "');\n";
    $configContent .= "define('SHOP_LANG', '" . addslashes($_POST['shop_language'] ?? 'pl') . "');\n";
    $configContent .= "define('SHOP_CURRENCY', '" . addslashes($_POST['shop_currency'] ?? 'PLN') . "');\n";

    // Zapis pliku
    $configFile = dirname(__DIR__) . '/config.php';
    
    // Sprawdź uprawnienia do zapisu
    if (!is_writable(dirname($configFile))) {
        die('Brak uprawnień do zapisu w katalogu: ' . dirname($configFile));
    }

    if (file_put_contents($configFile, $configContent)) {
// W sekcji zapisu danych do sesji:
$_SESSION['install_data'] = [
    'admin_email' => $_POST['admin_email'],
    'admin_username' => $_POST['admin_username'],
    'shop_url' => $_POST['shop_url'],
    'admin_password_plain' => $_POST['admin_password'] // Zapisz oryginalne hasło
];
        header('Location: finish.php');
        exit;
    } else {
        $error = error_get_last();
        die('Nie udało się zapisać pliku konfiguracyjnego. Błąd: ' . $error['message']);
    }
} catch (PDOException $e) {
    die('Błąd bazy danych: ' . $e->getMessage());
} catch (Exception $e) {
    die('Wystąpił błąd: ' . $e->getMessage());
}
