
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalator AZShop</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="installer-container">
        <div class="header">
            <h1><span class="az">AZ</span>Shop Installer</h1>
            <div class="progress-bar">
                <div class="progress-step active">1</div>
                <div class="progress-step">2</div>
                <div class="progress-step">3</div>
            </div>
        </div>

        <form id="installForm" action="process.php" method="post">
<!-- ...początek HTML bez zmian... -->
<div class="form-section active" id="section-database">
    <h2>Konfiguracja bazy danych</h2>
    <div class="form-group">
        <label for="db_host">Host bazy danych</label>
        <input type="text" id="db_host" name="db_host" value="localhost" required>
    </div>
    <div class="form-group">
        <label for="db_name">Nazwa bazy danych</label>
        <input type="text" id="db_name" name="db_name" required>
    </div>
    <div class="form-group">
        <label for="db_user">Użytkownik bazy danych</label>
        <input type="text" id="db_user" name="db_user" required>
    </div>
    <div class="form-group">
        <label for="db_pass">Hasło bazy danych</label>
        <input type="password" id="db_pass" name="db_pass">
    </div>
</div>
<!-- ...reszta formularza bez zmian... -->


            <div class="form-section" id="section-admin">
                <h2>Konto administratora</h2>
                <div class="form-group">
                    <label for="admin_email">Email administratora</label>
                    <input type="email" id="admin_email" name="admin_email" required>
                </div>
                <div class="form-group">
                    <label for="admin_username">Nazwa użytkownika</label>
                    <input type="text" id="admin_username" name="admin_username" required>
                </div>
                <div class="form-group">
                    <label for="admin_password">Hasło</label>
                    <input type="password" id="admin_password" name="admin_password" required>
                    <div class="password-strength">
                        <div class="strength-bar"></div>
                        <div class="strength-text">Słabe</div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="admin_password_confirm">Potwierdź hasło</label>
                    <input type="password" id="admin_password_confirm" name="admin_password_confirm" required>
                </div>
            </div>

            <div class="form-section" id="section-settings">
                <h2>Ustawienia sklepu</h2>
                <div class="form-group">
                    <label for="shop_name">Nazwa sklepu</label>
                    <input type="text" id="shop_name" name="shop_name" required>
                </div>
                <div class="form-group">
                    <label for="shop_url">URL sklepu</label>
                    <input type="url" id="shop_url" name="shop_url" required>
                </div>
                <div class="form-group">
                    <label for="shop_language">Język</label>
                    <select id="shop_language" name="shop_language">
                        <option value="pl">Polski</option>
                        <option value="en">English</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="shop_currency">Waluta</label>
                    <select id="shop_currency" name="shop_currency">
                        <option value="PLN">PLN</option>
                        <option value="EUR">EUR</option>
                        <option value="USD">USD</option>
                    </select>
                </div>
            </div>

            <div class="navigation-buttons">
                <button type="button" id="prevBtn" class="btn-secondary" disabled>Wstecz</button>
                <button type="button" id="nextBtn" class="btn-primary">Dalej</button>
                <button type="submit" id="submitBtn" class="btn-primary" style="display: none;">Zainstaluj</button>
            </div>
        </form>
    </div>

    <script src="assets/js/main.js"></script>
</body>
</html>