<?php
session_start();

// Sprawdź czy instalacja została już wykonana i czy są dane w sesji
if (!file_exists(dirname(__DIR__) . '/config.php') || !isset($_SESSION['install_data'])) {
    header('Location: index.php');
    exit;
}

// Pobierz dane z sesji
$installData = $_SESSION['install_data'];

// Wyczyść dane sesji po użyciu
unset($_SESSION['install_data']);
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalacja zakończona - AZShop</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="installer-container">
        <div class="header">
            <h1><span class="az">AZ</span>Shop Instalacja zakończona</h1>
        </div>

        <div class="success-message">
            <svg viewBox="0 0 24 24" width="80" height="80" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                <polyline points="22 4 12 14.01 9 11.01"></polyline>
            </svg>
            <h2>Instalacja zakończona pomyślnie!</h2>
            <p>System AZShop został poprawnie zainstalowany. Możesz teraz zalogować się do panelu administracyjnego.</p>
            
            <div class="installation-details">
    <h3>Dane do logowania:</h3>
    <p><strong>Email:</strong> <?php echo htmlspecialchars($installData['admin_email']); ?></p>
    <p><strong>Nazwa użytkownika:</strong> <?php echo htmlspecialchars($installData['admin_username']); ?></p>
    <p><strong>Hasło:</strong> <?php echo htmlspecialchars($installData['admin_password_plain']); ?></p>
</div>
            
            <div class="actions">
                <a href="<?php echo htmlspecialchars($installData['shop_url']); ?>/dashboard" class="btn-primary">Przejdź do panelu administracyjnego</a>
                <a href="<?php echo htmlspecialchars($installData['shop_url']); ?>" class="btn-secondary">Zobacz sklep</a>
            </div>
            

<div class="security-warning">
    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round">
        <circle cx="12" cy="12" r="10"></circle>
        <line x1="12" y1="8" x2="12" y2="12"></line>
        <line x1="12" y1="16" x2="12.01" y2="16"></line>
    </svg>
    <p><strong>UWAGA:</strong> Hasło jest widoczne tylko teraz! Zapisz je w bezpiecznym miejscu.</p>
</div>

<script>

// Usuń hasło z pamięci po 60 sekundach
setTimeout(function() {
    fetch('clear_password.php'); // Wykonaj żądanie do czyszczenia
}, 60000);
</script>
        </div>
    </div>
</body>
</html>